this.name        = "reticle_target_sensitive"; 
this.author      = "eric walch"; 
this.copyright   = ""; 
this.description = "Equipment that sets the target reticle to red when on target"; 
this.version     = "1.2";
/*
  Added code to determine if the HUD already has the equipment defined. In that case don't remove the function.
  Should also work when player switches ships by downgrading. (Not testet yet)
*/

this.startUp = function()
{
    this.reset();
}

this.reset = function()
{

    this.checkReticleInHud();
    if(missionVariables.reticleTargetSensitive == "TRUE")
    {
        player.ship.reticleTargetSensitive = true
    }
}

this.checkReticleInHud = function()
{
    if(player.ship.reticleTargetSensitive) missionVariables.reticleTargetInHud = player.ship.name;
    else missionVariables.reticleTargetInHud = null; // missionVariables is needed to suppress equipment on equip screen.
}

this.playerBoughtNewShip = function()
{
    this.checkReticleInHud();
    
    if(player.ship.hasEquipment("EQ_RETICLE_TARGET_SENSITIVE"))
    {
        missionVariables.reticleTargetSensitive = "TRUE"
        player.ship.reticleTargetSensitive = true
    }
    else missionVariables.reticleTargetSensitive = null
}

this.playerBoughtEquipment = function(equipment)
{
    if(equipment == "EQ_RETICLE_TARGET_SENSITIVE")
    {
        player.ship.reticleTargetSensitive = true
        missionVariables.reticleTargetSensitive = "TRUE"
        player.ship.removeEquipment("EQ_RETICLE_TARGET_SENSITIVE")
    }
    if(equipment == "EQ_SCANNER_SHOW_MISSILE_TARGET")
    {
        if(missionVariables.reticleTargetInHud && missionVariables.reticleTargetInHud != player.ship.name) this.checkReticleInHud();
        if(!missionVariables.reticleTargetInHud) player.ship.reticleTargetSensitive = false
        missionVariables.reticleTargetSensitive = null
    }
}

this.equipmentDamaged = this.equipmentDestroyed  = function(equipment)
{
    if(equipment == "EQ_SCANNER_SHOW_MISSILE_TARGET")
    {
        if(!missionVariables.reticleTargetInHud) player.ship.reticleTargetSensitive = false
        missionVariables.reticleTargetSensitive = null
    }
}